﻿using System.ComponentModel;
using System.Windows.Media;

namespace KoloryWPF.ModelWidoku
{
    using Model;

    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                OnPropertyChanged("G", "Color");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                OnPropertyChanged("B", "Color");
            }
        }

        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }

        public void Zapisz()
        {
            Ustawienia.Zapisz(kolor);
        }
    }

    public class EdycjaKoloru2 : INotifyPropertyChanged
    {
        public EdycjaKoloru2()
        {
            Kolor kolor = Ustawienia.Czytaj();
            R = kolor.R;
            G = kolor.G;
            B = kolor.B;
        }

        private byte r, g, b;

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        public byte R
        {
            get
            {
                return r;
            }
            set
            {
                r = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return g;
            }
            set
            {
                g = value;
                OnPropertyChanged("G", "Color");
            }
        }

        public byte B
        {
            get
            {
                return b;
            }
            set
            {
                b = value;
                OnPropertyChanged("B", "Color");
            }
        }


        public Color Color
        {
            get
            {
                return Color.FromRgb(R, G, B);
            }
        }

        public void Zapisz()
        {
            Kolor kolor = new Kolor(R, G, B);
            Ustawienia.Zapisz(kolor);
        }
    }

    public class EdycjaKoloru3
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public Kolor Kolor
        {
            get
            {
                return kolor;
            }
        }

        public Color Color
        {
            get
            {
                return Kolor.ToColor();
            }
        }

        public void Zapisz()
        {
            Ustawienia.Zapisz(Kolor);
        }
    }

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return new Color()
            {
                A = 255,
                R = kolor.R,
                G = kolor.G,
                B = kolor.B
            };
        }
    }
}
